#version 330
#extension GL_EXT_gpu_shader4 : enable
//Fractal FishMod01.fsh  by   Logos
//https://www.shadertoy.com/view/XdlGRH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Robert Śmietana (Logos) - 03.04.2019
// Bielsko-Biała, Poland, UE, Earth, Sol, Milky Way, Local Group, Laniakea :)


vec3 pixelColor(vec2 p)
{
    
    //--- calculate water (background) color ---//
    
    vec3 wc = vec3(0.0, 0.2 + 0.4*(0.5 - 0.5*p.y), 0.3 + 0.4*(0.5 - 0.5*p.y));
    wc += vec3(0.08*sin(p.y - p.x));
    
    
    //--- get main body of the fish ---//
    
    if (p.x < 3.968)
    {
        p = vec2(p.x, -p.y) / dot(p, p);
    }

    
	//--- carve tail of the fish ---//
    
    else
    {
		p.x -= 3.687;
        if (0.359 - 0.2*cos(5.0*p.y) < dot(p, p)) return wc;
    }

    
    //--- iterate mandelbrot and return pixel color ---//
    
	vec2 z = vec2(p);  
	for (int i = 1; i <= 100; i++)
    {  
		z = vec2(z.x*z.x - z.y*z.y, 2.0*z.x*z.y) + p; 

		if (504.0 + 300.0*sin(4.1*iTime) < dot(z, z))
        {
			return z.y < 0.0? vec3(0.0) : vec3(1.0);
		}
	}

    
    //--- that was water :) ---//
    
    return wc;
    
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    
    //--- calculate point coordinates ---//
    
	vec2 c = 2.1*(-2.0*gl_FragCoord.xy/iResolution.xy + 0.9)*vec2(iResolution.x/iResolution.y, 1.0) - vec2(-2.0, 0.0);
    
    
    //--- animate fish movement ---//

    c.x += 0.3*sin(0.4*iTime);
    c.y += 0.15 - 0.3*sin(0.43*iTime) + 0.2*cos(c.x);
    
    
    //--- add tail swing ---//
    
    if (0.0 < c.x) c.x += 0.1*c.x*cos(2.0*iTime + sin(0.8*c.x));
    

    //--- calculate final pixel color ---//
    
    float a = 3.0;
    float e = 1.0/min(iResolution.x, iResolution.y);    
    vec3 col = vec3(0.0);
    
    for (float j = -a; j < a; j++)
        for (float i = -a; i < a; i++)
            col += pixelColor(c + 2.1*vec2(i, j) * (e/a)) / (4.0*a*a);

	gl_FragColor = vec4(col, 1.0);
    
}